package model;

import java.util.List;
import java.util.Observable;

public class ProxyEvent extends Observable implements IEvent {

	private IEvent event;

	public ProxyEvent(IEvent event) {
		super();
		this.event = event;
	}

	public void setEvent(Event event) {
		this.event = event;
		// update();
	}

	public List<String> getEvents() {
		return event.getEvents();
	}

	public void setEvent(String event) {
		this.event.setEvent(event);

	}

	public List<Integer> getDates() {
		return this.event.getDates();
	}

	public void setDate(int date) {
		this.event.setDate(date);

	}

	public List<String> getPlaces() {
		return this.event.getPlaces();
	}

	public void setPlace(String place) {
		this.event.setPlace(place);
		update();
	}

	public void setFilter(String filter) {
		this.event.setFilter(filter);
		update();
	}

	@Override
	public String getFilter() {
		return event.getFilter();
	}

	public void update() {
		setChanged();
		notifyObservers();
	}

}
